package edu.columbia.cs.itx.dsadmin;

import javax.swing.*;
import javax.swing.event.*;
import javax.swing.table.*;
import java.awt.*;
import java.awt.event.*;
import oracle.jdeveloper.layout.*;

public class DSManagerMainFrame extends JFrame {
  JMenuBar menuBar1 = new JMenuBar();
  JMenu menuFile = new JMenu();
  JMenuItem menuConfig = new JMenuItem();
  JMenuItem menuLogin = new JMenuItem();
  JMenuItem menuAddUser = new JMenuItem();
  JMenuItem menuRemoveUser = new JMenuItem();
  JMenuItem menuFileExit = new JMenuItem();
  JMenu menuHelp = new JMenu();
  JMenuItem menuHelpAbout = new JMenuItem();
  JToolBar toolBar = new JToolBar();
  JButton buttonLogin = new JButton();
  JButton buttonAddUser = new JButton();
  JButton buttonRemoveUser = new JButton();
  BorderLayout borderLayout1 = new BorderLayout();
  JSplitPane jSplitPane1 = new JSplitPane(JSplitPane.HORIZONTAL_SPLIT);
  JScrollPane infoPane = new JScrollPane();
  JScrollPane tablePane = new JScrollPane();
  JTextArea infoArea = new JTextArea();
  JTable usersTable = new JTable();
  ListSelectionModel rowSM;
  
  public DSManagerMainFrame() {
    super();
    try  {
      jbInit();
      buttonLogin.setText("Login");
      buttonAddUser.setText("Add User");
      buttonRemoveUser.setText("Remove User");
    }
    catch (Exception e) {
      e.printStackTrace();
    }
  }

  private void jbInit() throws Exception {
    this.getContentPane().setLayout(borderLayout1);
    this.setSize(new Dimension(800, 600));
    this.setTitle("ITX Directory Service Manager");
    menuFile.setText("File");
    menuConfig.setText("Load Configuration");
    menuLogin.setText("Login");
    menuAddUser.setText("Add User");
    menuRemoveUser.setText("Remove User");
    menuFileExit.setText("Exit");
    menuFileExit.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) {
        fileExit_ActionPerformed(e);
      }
    });
    menuHelp.setText("Help");
    menuHelpAbout.setText("About");
    menuHelpAbout.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) {
        helpAbout_ActionPerformed(e);
      }
    });
    buttonLogin.setToolTipText("Login");
    buttonAddUser.setToolTipText("Add User");
    buttonRemoveUser.setToolTipText("Remove User");
    infoArea.setLineWrap(true);
    infoArea.setWrapStyleWord(true);
    infoArea.setText("This is where the instructions belong.");
    infoArea.setEditable(false);
    jSplitPane1.setLeftComponent(infoPane);
    jSplitPane1.setRightComponent(tablePane);
    jSplitPane1.setDividerLocation(250);
    menuFile.add(menuConfig);
    menuFile.add(menuLogin);
    menuFile.add(menuAddUser);
    menuFile.add(menuRemoveUser);
    menuFile.add(menuFileExit);
    menuBar1.add(menuFile);
    menuHelp.add(menuHelpAbout);
    menuBar1.add(menuHelp);
    this.setJMenuBar(menuBar1);
    toolBar.add(buttonLogin);
    toolBar.add(buttonAddUser);
    toolBar.add(buttonRemoveUser);

    infoPane.getViewport();

    this.getContentPane().add(jSplitPane1, BorderLayout.CENTER);
    jSplitPane1.add(infoPane, JSplitPane.LEFT);
    infoPane.getViewport().add(infoArea, null);
    jSplitPane1.add(tablePane, JSplitPane.RIGHT);
    usersTable.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
    rowSM = usersTable.getSelectionModel();
    tablePane.getViewport().add(usersTable, null);
    this.getContentPane().add(toolBar, BorderLayout.NORTH);
  }

  void fileExit_ActionPerformed(ActionEvent e) {
    System.exit(0);
  }

  void helpAbout_ActionPerformed(ActionEvent e) {
    JOptionPane.showMessageDialog(this, new DSManagerMainFrame_AboutBoxPanel1(), "About", JOptionPane.PLAIN_MESSAGE);
  }

  // set the model for the table
  void setTableModel(TableModel newModel) {
    usersTable.setModel(newModel);
  }

  public JTable getTable() {
    return usersTable;
  }

  public ListSelectionModel getTableSelectionModel() {
    return rowSM;
  }

  public void addAddUserMenuActionListener(ActionListener l) {
    menuAddUser.addActionListener(l);
  }

  public void addRemoveUserMenuActionListener(ActionListener l) {
    menuRemoveUser.addActionListener(l);
  }

  public void addAddUserButtonActionListener(ActionListener l) {
    buttonAddUser.addActionListener(l);
  }

  public void addRemoveUserButtonActionListener(ActionListener l) {
    buttonRemoveUser.addActionListener(l);
  }

  public void removeAddUserMenuActionListener(ActionListener l) {
    menuAddUser.removeActionListener(l);
  }

  public void removeRemoveUserMenuActionListener(ActionListener l) {
    menuRemoveUser.removeActionListener(l);
  }

  public void removeAddUserButtonActionListener(ActionListener l) {
    buttonAddUser.removeActionListener(l);
  }

  public void removeRemoveUserButtonActionListener(ActionListener l) {
    buttonRemoveUser.removeActionListener(l);
  }

  public void addLoginMenuActionListener(ActionListener l) {
    menuLogin.addActionListener(l);
  }

  public void addLoginButtonActionListener(ActionListener l) {
    buttonLogin.addActionListener(l);
  }

  public void addLoginActionListener(ActionListener l) {
    addLoginMenuActionListener(l);
    addLoginButtonActionListener(l);
  }

  public void addAddUserActionListener(ActionListener l) {
    addAddUserMenuActionListener(l);
    addAddUserButtonActionListener(l);
  }

  public void addRemoveUserActionListener(ActionListener l) {
    addRemoveUserMenuActionListener(l);
    addRemoveUserButtonActionListener(l);
  }

  public void removeAddUserActionListener(ActionListener l) {
    removeAddUserMenuActionListener(l);
    removeAddUserButtonActionListener(l);
  }

  public void removeRemoveUserActionListener(ActionListener l) {
    removeRemoveUserMenuActionListener(l);
    removeRemoveUserButtonActionListener(l);
  }

  public void setLoginMenuEnabled(boolean b) {
    menuLogin.setEnabled(b);
  }

  public void setLoginButtonEnabled(boolean b) {
    buttonLogin.setEnabled(b);
  }

  public void setLoginEnabled(boolean b) {
    setLoginMenuEnabled(b);
    setLoginButtonEnabled(b);
  }

  public void setAddUserMenuEnabled(boolean b) {
    menuAddUser.setEnabled(b);
  }

  public void setAddUserButtonEnabled(boolean b) {
    buttonAddUser.setEnabled(b);
  }

  public void setAddUserEnabled(boolean b) {
    setAddUserMenuEnabled(b);
    setAddUserButtonEnabled(b);
  }

  public void setRemoveUserMenuEnabled(boolean b) {
    menuRemoveUser.setEnabled(b);
  }

  public void setRemoveUserButtonEnabled(boolean b) {
    buttonRemoveUser.setEnabled(b);
  }

  public void setRemoveUserEnabled(boolean b) {
    setRemoveUserMenuEnabled(b);
    setRemoveUserButtonEnabled(b);
  }

  public void addConfigMenuActionListener(ActionListener l) {
    menuConfig.addActionListener(l);
  }
}

